# Arena 7x7 Ranking - Website

## Descricao
Website completo para o sistema de ranking Arena 7x7, com interface moderna e responsiva.

## Recursos

### Publicos (sem login)
- **Pagina Inicial** - Dashboard com estatisticas gerais e top 5 jogadores
- **Ranking** - Lista completa de jogadores com paginacao e filtros
- **Partidas** - Historico de todas as partidas com filtro por data
- **Busca** - Pesquisa avancada por jogadores, partidas e adversarios
- **Detalhes da Partida** - Visualizacao completa de uma partida
- **Perfil do Jogador** - Estatisticas detalhadas de um jogador

### Privados (requer login)
- **Meu Perfil** - Estatisticas consolidadas da conta
- **Minhas Partidas** - Historico filtrado pelos personagens da conta

## Instalacao

### Requisitos
- PHP 7.4 ou superior
- MySQL 5.7 ou superior
- Apache com mod_rewrite (opcional)
- PDO extensao habilitada

### Configuracao

1. **Copie a pasta `arena7x7` para seu servidor web**
   ```
   Exemplo: htdocs/arena7x7/ ou www/arena7x7/
   ```

2. **Configure o banco de dados**
   
   Edite o arquivo `includes/config.php`:
   ```php
   define('DB_HOST', 'localhost');
   define('DB_NAME', 'ragnarok');  // Nome do seu banco
   define('DB_USER', 'root');      // Usuario do MySQL
   define('DB_PASS', '');          // Senha do MySQL
   ```

3. **Verifique as tabelas**
   
   As tabelas necessarias devem existir no banco:
   - `arena7x7_matches`
   - `arena7x7_match_players`
   - `arena7x7_player_stats`
   - `arena7x7_kills`
   - `arena7x7_assists`
   - `arena7x7_heals`
   - `arena7x7_match_skills`
   - `login` (tabela padrao rAthena)
   - `char` (tabela padrao rAthena)

4. **Ajuste as permissoes**
   ```
   chmod 755 arena7x7/
   chmod 644 arena7x7/*.php
   chmod 644 arena7x7/includes/*.php
   ```

5. **Acesse o site**
   ```
   http://seu-servidor/arena7x7/
   ```

## Estrutura de Arquivos

```
arena7x7/
├── index.php           # Pagina inicial
├── login.php           # Tela de login
├── logout.php          # Encerrar sessao
├── ranking.php         # Ranking completo
├── matches.php         # Lista de partidas
├── match.php           # Detalhes da partida
├── player.php          # Perfil do jogador
├── profile.php         # Meu perfil (logado)
├── my_matches.php      # Minhas partidas (logado)
├── search.php          # Busca avancada
├── .htaccess           # Configuracoes Apache
├── includes/
│   ├── config.php      # Configuracoes do sistema
│   ├── db.php          # Classe de conexao PDO
│   ├── auth.php        # Sistema de autenticacao
│   ├── functions.php   # Funcoes auxiliares
│   ├── header.php      # Template do cabecalho
│   └── footer.php      # Template do rodape
└── assets/
    ├── css/
    │   └── style.css   # Estilos customizados
    ├── js/
    │   └── main.js     # JavaScript customizado
    └── images/
        └── placeholder.png
```

## Seguranca

O sistema inclui varias camadas de seguranca:

1. **SQL Injection** - Todas as queries usam PDO prepared statements
2. **XSS** - Funcao `e()` para escapar output HTML
3. **CSRF** - Tokens de protecao em formularios
4. **Sessao Segura** - Cookies httponly e regeneracao de ID
5. **Acesso Direto** - Includes protegidos com constante ARENA7X7
6. **Headers HTTP** - X-Frame-Options, X-XSS-Protection, etc

## Integracao Divine Pride

As imagens de skills, itens e classes sao carregadas diretamente do Divine Pride:

- **Skills**: `https://static.divine-pride.net/images/skill/`
- **Items**: `https://static.divine-pride.net/images/items/item/`
- **Classes**: `https://static.divine-pride.net/images/mobs/png/`

## Personalizacao

### Cores dos Times
Edite em `includes/config.php`:
```php
$TEAM_COLORS = [
    1 => ['name' => 'Time Azul', 'color' => '#3b82f6'],
    2 => ['name' => 'Time Vermelho', 'color' => '#ef4444']
];
```

### Itens por Pagina
```php
define('ITEMS_PER_PAGE', 20);
```

### Tema CSS
Edite as variaveis CSS em `assets/css/style.css`:
```css
:root {
    --primary-color: #6366f1;
    --bg-dark: #0f172a;
    /* ... */
}
```

## Troubleshooting

### Erro de conexao com banco
- Verifique as credenciais em `config.php`
- Confirme que o MySQL esta rodando
- Verifique se a extensao PDO esta habilitada

### Imagens nao carregam
- As imagens do Divine Pride requerem conexao com internet
- IDs de skills/classes devem estar corretos
- Use o fallback `assets/images/placeholder.png`

### Login nao funciona
- Verifique se a tabela `login` existe
- Confirme o metodo de hash (MD5 padrao rAthena)
- Verifique se a conta esta ativa (state = 0)

## Creditos

- **Divine Pride** - Imagens de skills e items
- **Bootstrap 5** - Framework CSS
- **Bootstrap Icons** - Icones
- **Google Fonts** - Fonte Poppins

## Licenca

Este projeto e parte do sistema Arena 7x7 para servidores rAthena/brHades.
Uso livre para servidores privados de Ragnarok Online.
