/**
 * Arena 7x7 - JavaScript Principal
 */

document.addEventListener('DOMContentLoaded', function() {
    
    // Inicializar tooltips do Bootstrap
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
    
    // Inicializar popovers do Bootstrap
    var popoverTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="popover"]'));
    var popoverList = popoverTriggerList.map(function (popoverTriggerEl) {
        return new bootstrap.Popover(popoverTriggerEl);
    });
    
    // Auto-dismiss alerts apos 5 segundos
    var alerts = document.querySelectorAll('.alert-dismissible');
    alerts.forEach(function(alert) {
        setTimeout(function() {
            var bsAlert = new bootstrap.Alert(alert);
            bsAlert.close();
        }, 5000);
    });
    
    // Tratamento de erro para imagens de skills/items do Divine Pride
    document.querySelectorAll('.skill-icon, .item-icon').forEach(function(img) {
        img.addEventListener('error', function() {
            this.src = 'assets/images/placeholder.png';
            this.classList.add('img-error');
        });
    });
    
    // Confirmar acoes destrutivas
    document.querySelectorAll('[data-confirm]').forEach(function(element) {
        element.addEventListener('click', function(e) {
            var message = this.getAttribute('data-confirm') || 'Tem certeza que deseja realizar esta acao?';
            if (!confirm(message)) {
                e.preventDefault();
            }
        });
    });
    
    // Formatador de numeros
    window.formatNumber = function(num) {
        return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
    };
    
    // Atualizar numeros formatados
    document.querySelectorAll('[data-format-number]').forEach(function(element) {
        var value = parseInt(element.textContent);
        if (!isNaN(value)) {
            element.textContent = formatNumber(value);
        }
    });
    
    // Copiar para clipboard
    document.querySelectorAll('[data-copy]').forEach(function(element) {
        element.addEventListener('click', function() {
            var text = this.getAttribute('data-copy');
            navigator.clipboard.writeText(text).then(function() {
                // Feedback visual
                var originalText = element.innerHTML;
                element.innerHTML = '<i class="bi bi-check"></i> Copiado!';
                setTimeout(function() {
                    element.innerHTML = originalText;
                }, 2000);
            });
        });
    });
    
    // Filtro de busca na tabela
    var searchInput = document.getElementById('tableSearch');
    if (searchInput) {
        searchInput.addEventListener('input', function() {
            var filter = this.value.toLowerCase();
            var table = document.querySelector(this.getAttribute('data-table'));
            if (table) {
                var rows = table.querySelectorAll('tbody tr');
                rows.forEach(function(row) {
                    var text = row.textContent.toLowerCase();
                    row.style.display = text.includes(filter) ? '' : 'none';
                });
            }
        });
    }
    
    // Toggle de tema claro/escuro (futuro)
    var themeToggle = document.getElementById('themeToggle');
    if (themeToggle) {
        themeToggle.addEventListener('click', function() {
            document.body.classList.toggle('theme-light');
            localStorage.setItem('theme', document.body.classList.contains('theme-light') ? 'light' : 'dark');
        });
        
        // Carregar tema salvo
        if (localStorage.getItem('theme') === 'light') {
            document.body.classList.add('theme-light');
        }
    }
    
    // Animacao de entrada para cards
    var observer = new IntersectionObserver(function(entries) {
        entries.forEach(function(entry) {
            if (entry.isIntersecting) {
                entry.target.classList.add('fade-in');
                observer.unobserve(entry.target);
            }
        });
    }, { threshold: 0.1 });
    
    document.querySelectorAll('.card, .match-card').forEach(function(element) {
        observer.observe(element);
    });
    
    // Contador animado
    function animateCounter(element, target, duration) {
        var start = 0;
        var increment = target / (duration / 16);
        
        function update() {
            start += increment;
            if (start < target) {
                element.textContent = formatNumber(Math.floor(start));
                requestAnimationFrame(update);
            } else {
                element.textContent = formatNumber(target);
            }
        }
        
        requestAnimationFrame(update);
    }
    
    // Animar contadores quando visiveis
    document.querySelectorAll('[data-animate-counter]').forEach(function(element) {
        var target = parseInt(element.getAttribute('data-animate-counter'));
        var animated = false;
        
        var counterObserver = new IntersectionObserver(function(entries) {
            entries.forEach(function(entry) {
                if (entry.isIntersecting && !animated) {
                    animated = true;
                    animateCounter(element, target, 1000);
                    counterObserver.unobserve(element);
                }
            });
        }, { threshold: 0.5 });
        
        counterObserver.observe(element);
    });
    
});

// Funcao para carregar mais itens via AJAX (paginacao infinita - futuro)
function loadMoreItems(url, container, button) {
    button.disabled = true;
    button.innerHTML = '<span class="spinner-border spinner-border-sm" role="status"></span> Carregando...';
    
    fetch(url)
        .then(response => response.text())
        .then(html => {
            container.insertAdjacentHTML('beforeend', html);
            button.disabled = false;
            button.innerHTML = 'Carregar mais';
        })
        .catch(error => {
            console.error('Erro ao carregar:', error);
            button.disabled = false;
            button.innerHTML = 'Tentar novamente';
        });
}

// Funcao para atualizar estatisticas em tempo real (WebSocket - futuro)
function connectWebSocket() {
    // Implementar quando necessario
    console.log('WebSocket nao implementado');
}
