<?php
/**
 * Arena 7x7 - Guild Emblem Endpoint
 * Serve os emblemas das guilds armazenados como BLOB no banco
 */

define('ARENA7X7', true);
require_once 'includes/config.php';
require_once 'includes/db.php';

// Obter guild_id
$guild_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($guild_id <= 0) {
    // Retornar imagem placeholder transparente
    header('Content-Type: image/png');
    $img = imagecreatetruecolor(24, 24);
    imagesavealpha($img, true);
    $transparent = imagecolorallocatealpha($img, 0, 0, 0, 127);
    imagefill($img, 0, 0, $transparent);
    imagepng($img);
    imagedestroy($img);
    exit;
}

// Cache headers (1 hora)
header('Cache-Control: public, max-age=3600');
header('Expires: ' . gmdate('D, d M Y H:i:s', time() + 3600) . ' GMT');

// Buscar emblema do banco
$sql = "SELECT file_type, file_data FROM guild_emblems WHERE guild_id = :guild_id ORDER BY version DESC LIMIT 1";
$emblem = db()->fetchOne($sql, ['guild_id' => $guild_id]);

if ($emblem && !empty($emblem['file_data'])) {
    // Determinar content-type baseado no file_type ou detectar
    $fileType = $emblem['file_type'];
    $data = $emblem['file_data'];
    
    // O rAthena geralmente salva como BMP ou já convertido
    // Verificar magic bytes para determinar o tipo real
    $magicBytes = substr($data, 0, 4);
    
    if (substr($magicBytes, 0, 2) === 'BM') {
        // É um BMP - converter para PNG para melhor compatibilidade web
        header('Content-Type: image/png');
        
        // Criar imagem temporária do BMP
        $tempFile = tempnam(sys_get_temp_dir(), 'emblem_');
        file_put_contents($tempFile, $data);
        
        $img = @imagecreatefrombmp($tempFile);
        if ($img) {
            // Habilitar transparência
            imagesavealpha($img, true);
            imagepng($img);
            imagedestroy($img);
        } else {
            // Fallback: enviar como está
            header('Content-Type: image/bmp');
            echo $data;
        }
        
        unlink($tempFile);
    } elseif (substr($magicBytes, 0, 3) === 'GIF') {
        header('Content-Type: image/gif');
        echo $data;
    } elseif (substr($magicBytes, 0, 8) === "\x89PNG\r\n\x1a\n" || substr($magicBytes, 0, 4) === "\x89PNG") {
        header('Content-Type: image/png');
        echo $data;
    } elseif (substr($magicBytes, 0, 2) === "\xFF\xD8") {
        header('Content-Type: image/jpeg');
        echo $data;
    } else {
        // Tentar usar o file_type informado ou enviar como octet-stream
        if (strpos($fileType, 'image/') === 0) {
            header('Content-Type: ' . $fileType);
        } else {
            header('Content-Type: image/png');
        }
        echo $data;
    }
} else {
    // Emblema não encontrado - retornar placeholder
    header('Content-Type: image/png');
    
    // Criar uma imagem placeholder com as iniciais ou ícone de guild
    $img = imagecreatetruecolor(24, 24);
    imagesavealpha($img, true);
    
    // Fundo semi-transparente
    $bg = imagecolorallocatealpha($img, 50, 50, 70, 50);
    imagefill($img, 0, 0, $bg);
    
    // Borda
    $border = imagecolorallocate($img, 100, 100, 120);
    imagerectangle($img, 0, 0, 23, 23, $border);
    
    // Texto "G" no centro
    $white = imagecolorallocate($img, 200, 200, 200);
    imagestring($img, 3, 8, 5, 'G', $white);
    
    imagepng($img);
    imagedestroy($img);
}
