<?php
/**
 * Arena 7x7 - Configuracao do Sistema
 * Configuracoes de banco de dados e sistema
 */

// Prevenir acesso direto
if (!defined('ARENA7X7')) {
    die('Acesso negado.');
}

// Configuracoes do Banco de Dados
define('DB_HOST', 'localhost');
define('DB_NAME', 'rwc');      // Nome do banco do rAthena
define('DB_USER', 'root');      // Usuario do banco
define('DB_PASS', 'root');      // Senha do banco
define('DB_CHARSET', 'utf8mb4');

// Configuracoes do Site
define('SITE_NAME', 'Arena 7x7 Ranking');
define('SITE_URL', 'http://localhost/arena7x7/');

// Configuracoes de Seguranca
define('SESSION_NAME', 'arena7x7_session');
define('SESSION_LIFETIME', 3600); // 1 hora
define('CSRF_TOKEN_NAME', 'csrf_token');

// Modo de producao - true para esconder erros e informacoes sensiveis
define('PRODUCTION_MODE', true);

// Chave secreta para hash de URLs (altere para sua propria chave)
define('URL_HASH_SECRET', 'arena7x7_secret_key_2025_change_me');

// Divine Pride API para imagens
define('DIVINE_PRIDE_URL', 'https://static.divine-pride.net');
define('SKILL_IMG_URL', DIVINE_PRIDE_URL . '/images/skill/');
define('ITEM_IMG_URL', DIVINE_PRIDE_URL . '/images/items/item/');

// Configuracoes de Paginacao
define('ITEMS_PER_PAGE', 20);

// Tabelas do rAthena
define('TABLE_LOGIN', 'login');
define('TABLE_CHAR', 'char');

// Tabelas do Arena 7x7
define('TABLE_MATCHES', 'arena7x7_matches');
define('TABLE_MATCH_PLAYERS', 'arena7x7_match_players');
define('TABLE_MATCH_STATS', 'arena7x7_match_stats');
define('TABLE_RANKING', 'arena7x7_ranking');
define('TABLE_RANKING_CLASS', 'arena7x7_ranking_by_class');
define('TABLE_KILLS', 'arena7x7_kills');
define('TABLE_DAMAGE_LOG', 'arena7x7_damage_log');
define('TABLE_DAMAGE_SKILL', 'arena7x7_damage_by_skill');
define('TABLE_DAMAGE_TARGET', 'arena7x7_damage_by_target');

// Mapeamento de Classes
$JOB_CLASSES = [
    0 => 'Novice',
    1 => 'Swordman',
    2 => 'Mage',
    3 => 'Archer',
    4 => 'Acolyte',
    5 => 'Merchant',
    6 => 'Thief',
    7 => 'Knight',
    8 => 'Priest',
    9 => 'Wizard',
    10 => 'Blacksmith',
    11 => 'Hunter',
    12 => 'Assassin',
    13 => 'Knight (Peco)',
    14 => 'Crusader',
    15 => 'Monk',
    16 => 'Sage',
    17 => 'Rogue',
    18 => 'Alchemist',
    19 => 'Bard',
    20 => 'Dancer',
    21 => 'Crusader (Peco)',
    4001 => 'High Novice',
    4002 => 'High Swordman',
    4003 => 'High Mage',
    4004 => 'High Archer',
    4005 => 'High Acolyte',
    4006 => 'High Merchant',
    4007 => 'High Thief',
    4008 => 'Lord Knight',
    4009 => 'High Priest',
    4010 => 'High Wizard',
    4011 => 'Whitesmith',
    4012 => 'Sniper',
    4013 => 'Assassin Cross',
    4014 => 'Lord Knight (Peco)',
    4015 => 'Paladin',
    4016 => 'Champion',
    4017 => 'Professor',
    4018 => 'Stalker',
    4019 => 'Creator',
    4020 => 'Clown',
    4021 => 'Gypsy',
    4022 => 'Paladin (Peco)',
    4023 => 'Baby Novice',
    4046 => 'Super Novice',
    4047 => 'Gunslinger',
    4049 => 'Ninja',
    4054 => 'Rune Knight',
    4055 => 'Warlock',
    4056 => 'Ranger',
    4057 => 'Arch Bishop',
    4058 => 'Mechanic',
    4059 => 'Guillotine Cross',
    4060 => 'Royal Guard',
    4061 => 'Sorcerer',
    4062 => 'Minstrel',
    4063 => 'Wanderer',
    4064 => 'Sura',
    4065 => 'Genetic',
    4066 => 'Shadow Chaser',
    4096 => 'Rune Knight T',
    4097 => 'Warlock T',
    4098 => 'Ranger T',
    4099 => 'Arch Bishop T',
    4100 => 'Mechanic T',
    4101 => 'Guillotine Cross T',
    4102 => 'Royal Guard T',
    4103 => 'Sorcerer T',
    4104 => 'Minstrel T',
    4105 => 'Wanderer T',
    4106 => 'Sura T',
    4107 => 'Genetic T',
    4108 => 'Shadow Chaser T',
    4190 => 'Dragon Knight',
    4191 => 'Meister',
    4192 => 'Shadow Cross',
    4193 => 'Arch Mage',
    4194 => 'Cardinal',
    4195 => 'Windhawk',
    4196 => 'Imperial Guard',
    4197 => 'Biolo',
    4198 => 'Abyss Chaser',
    4199 => 'Elemental Master',
    4200 => 'Inquisitor',
    4201 => 'Troubadour',
    4202 => 'Trouvere',
];

// Cores dos Times
$TEAM_COLORS = [
    1 => ['name' => 'Blue Team', 'color' => '#00BFFF', 'bg' => '#1a3a5c'],
    2 => ['name' => 'Red Team', 'color' => '#FF6347', 'bg' => '#5c1a1a'],
];
