<?php
/**
 * Arena 7x7 - Pagina Inicial
 * Dashboard com estatisticas e top players
 */

define('ARENA7X7', true);
require_once 'includes/config.php';
require_once 'includes/db.php';
require_once 'includes/auth.php';
require_once 'includes/functions.php';

Auth::startSession();

$pageTitle = 'Inicio';

// Buscar estatisticas gerais
$totalMatches = db()->fetchColumn("SELECT COUNT(*) FROM arena7x7_matches") ?? 0;
$totalPlayers = db()->fetchColumn("SELECT COUNT(DISTINCT char_id) FROM arena7x7_match_players") ?? 0;
$totalKills = db()->fetchColumn("SELECT SUM(total_kills) FROM arena7x7_ranking") ?? 0;
$totalDamage = db()->fetchColumn("SELECT SUM(total_damage_done) FROM arena7x7_ranking") ?? 0;

// Top 5 jogadores
$topPlayers = getTopPlayers(5);

// Partidas recentes
$recentMatches = getRecentMatches(5);

include 'includes/header.php';
?>

<!-- Hero Section -->
<div class="hero-section">
    <h1><i class="bi bi-trophy-fill text-warning me-2"></i>Arena 7x7 Ranking</h1>
    <p>Acompanhe suas estatisticas, veja o ranking dos melhores jogadores e reviva suas melhores partidas!</p>
    <div class="mt-4">
        <a href="ranking.php" class="btn btn-primary btn-lg me-2">
            <i class="bi bi-bar-chart me-2"></i>Ver Ranking Completo
        </a>
        <?php if (!Auth::isLoggedIn()): ?>
            <a href="login.php" class="btn btn-outline-primary btn-lg">
                <i class="bi bi-box-arrow-in-right me-2"></i>Fazer Login
            </a>
        <?php else: ?>
            <a href="my_matches.php" class="btn btn-outline-primary btn-lg">
                <i class="bi bi-controller me-2"></i>Minhas Partidas
            </a>
        <?php endif; ?>
    </div>
</div>

<!-- Estatisticas Gerais -->
<div class="row g-4 mb-5">
    <div class="col-md-3">
        <div class="card stat-card stat-rating">
            <i class="bi bi-controller stat-icon"></i>
            <div class="stat-value" data-animate-counter="<?= $totalMatches ?>"><?= formatNumber($totalMatches) ?></div>
            <div class="stat-label">Partidas Jogadas</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card stat-card stat-wins">
            <i class="bi bi-people stat-icon"></i>
            <div class="stat-value" data-animate-counter="<?= $totalPlayers ?>"><?= formatNumber($totalPlayers) ?></div>
            <div class="stat-label">Jogadores</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card stat-card stat-kills">
            <i class="bi bi-lightning stat-icon"></i>
            <div class="stat-value" data-animate-counter="<?= $totalKills ?>"><?= formatNumber($totalKills) ?></div>
            <div class="stat-label">Total de Kills</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card stat-card stat-assists">
            <i class="bi bi-graph-up stat-icon"></i>
            <div class="stat-value"><?= formatNumber(round($totalDamage / 1000000, 1)) ?>M</div>
            <div class="stat-label">Dano Total</div>
        </div>
    </div>
</div>

<div class="row g-4">
    <!-- Top 5 Jogadores -->
    <div class="col-lg-7">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="bi bi-trophy text-warning me-2"></i>Top 5 Jogadores
                </h5>
                <a href="ranking.php" class="btn btn-sm btn-outline-primary">Ver todos</a>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-striped mb-0">
                        <thead>
                            <tr>
                                <th style="width: 60px;">#</th>
                                <th>Jogador</th>
                                <th class="text-center">Rating</th>
                                <th class="text-center">Vitorias</th>
                                <th class="text-center">KDA</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($topPlayers)): ?>
                                <tr>
                                    <td colspan="5" class="text-center text-muted py-4">
                                        Nenhum jogador encontrado ainda.
                                    </td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($topPlayers as $index => $player): ?>
                                    <?php 
                                        $position = $index + 1;
                                        $kda = calculateKDA($player['total_kills'], $player['total_deaths'], $player['total_assists']);
                                        $kdaClass = getKdaClass($kda);
                                    ?>
                                    <tr>
                                        <td>
                                            <span class="rank-position rank-<?= $position <= 3 ? $position : 'default' ?>">
                                                <?= $position ?>
                                            </span>
                                        </td>
                                        <td>
                                            <div class="player-info">
                                                <div class="player-avatar">
                                                    <img src="<?= classImage($player['class']) ?>" 
                                                         alt="<?= e(getClassName($player['class'])) ?>"
                                                         onerror="this.src='assets/images/placeholder.png'">
                                                </div>
                                                <div>
                                                <a href="<?= playerUrl($player['char_name']) ?>" class="player-name">
                                                        <?= e($player['char_name']) ?>
                                                    </a>
                                                    <div class="player-class"><?= e(getClassName($player['class'])) ?></div>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <span class="text-warning fw-bold"><?= formatNumber($player['rating_points']) ?></span>
                                        </td>
                                        <td class="text-center">
                                            <span class="text-success"><?= $player['wins'] ?></span>
                                            <span class="text-muted">/</span>
                                            <span class="text-danger"><?= $player['losses'] ?></span>
                                        </td>
                                        <td class="text-center">
                                            <span class="<?= $kdaClass ?>"><?= number_format($kda, 2) ?></span>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Partidas Recentes -->
    <div class="col-lg-5">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="bi bi-clock-history me-2"></i>Partidas Recentes
                </h5>
                <a href="matches.php" class="btn btn-sm btn-outline-primary">Ver todas</a>
            </div>
            <div class="card-body">
                <?php if (empty($recentMatches)): ?>
                    <p class="text-center text-muted py-4">
                        Nenhuma partida encontrada ainda.
                    </p>
                <?php else: ?>
                    <?php foreach ($recentMatches as $match): ?>
                        <a href="<?= matchUrl($match['match_id']) ?>" class="text-decoration-none">
                            <div class="card match-card mb-3">
                                <div class="match-header">
                                    <span class="match-id">Partida</span>
                                    <span class="match-date">
                                        <i class="bi bi-calendar me-1"></i>
                                        <?= formatDateTime($match['start_time']) ?>
                                    </span>
                                </div>
                                <div class="match-score">
                                    <div class="team-score team-blue">
                                        <i class="bi bi-circle-fill me-2" style="font-size: 0.5rem;"></i>
                                        <?= $match['team_blue_score'] ?>
                                    </div>
                                    <div class="vs">VS</div>
                                    <div class="team-score team-red">
                                        <?= $match['team_red_score'] ?>
                                        <i class="bi bi-circle-fill ms-2" style="font-size: 0.5rem;"></i>
                                    </div>
                                </div>
                                <div class="text-center mt-2">
                                    <?php if ($match['winner_team'] == 1): ?>
                                        <span class="team-badge team-badge-blue"><?= e($match['blue_guild_name']) ?> Venceu</span>
                                    <?php elseif ($match['winner_team'] == 2): ?>
                                        <span class="team-badge team-badge-red"><?= e($match['red_guild_name']) ?> Venceu</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">Empate</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </a>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
