<?php
/**
 * Arena 7x7 - Pagina de Login
 */

define('ARENA7X7', true);
require_once 'includes/config.php';
require_once 'includes/db.php';
require_once 'includes/auth.php';
require_once 'includes/functions.php';

Auth::startSession();

// Se ja estiver logado, redirecionar
if (Auth::isLoggedIn()) {
    redirect('index.php');
}

$error = '';

// Processar login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validar CSRF
    if (!Auth::validateCsrfToken($_POST[CSRF_TOKEN_NAME] ?? '')) {
        $error = 'Sessao expirada. Tente novamente.';
    } else {
        $username = postParam('username');
        $password = postParam('password');
        
        $result = Auth::login($username, $password);
        
        if ($result['success']) {
            setFlash('success', 'Bem-vindo de volta, ' . e($username) . '!');
            redirect('index.php');
        } else {
            $error = $result['message'];
        }
    }
}

$pageTitle = 'Login';
include 'includes/header.php';
?>

<div class="login-container">
    <div class="card login-card">
        <div class="login-logo">
            <i class="bi bi-trophy-fill"></i>
        </div>
        
        <div class="login-title">
            <h3>Entrar no Sistema</h3>
            <p class="text-muted">Use suas credenciais do servidor</p>
        </div>
        
        <?php if ($error): ?>
            <div class="alert alert-danger" role="alert">
                <i class="bi bi-exclamation-triangle me-2"></i><?= e($error) ?>
            </div>
        <?php endif; ?>
        
        <form method="POST" action="">
            <?= Auth::csrfField() ?>
            
            <div class="mb-3">
                <label for="username" class="form-label">Usuario</label>
                <div class="input-group">
                    <span class="input-group-text bg-transparent border-end-0">
                        <i class="bi bi-person"></i>
                    </span>
                    <input type="text" 
                           class="form-control border-start-0" 
                           id="username" 
                           name="username" 
                           placeholder="Seu usuario do servidor"
                           value="<?= e(postParam('username', '')) ?>"
                           required 
                           autofocus>
                </div>
            </div>
            
            <div class="mb-4">
                <label for="password" class="form-label">Senha</label>
                <div class="input-group">
                    <span class="input-group-text bg-transparent border-end-0">
                        <i class="bi bi-lock"></i>
                    </span>
                    <input type="password" 
                           class="form-control border-start-0" 
                           id="password" 
                           name="password" 
                           placeholder="Sua senha"
                           required>
                </div>
            </div>
            
            <div class="d-grid">
                <button type="submit" class="btn btn-primary btn-lg">
                    <i class="bi bi-box-arrow-in-right me-2"></i>Entrar
                </button>
            </div>
        </form>
        
        <div class="text-center mt-4">
            <a href="index.php" class="text-muted">
                <i class="bi bi-arrow-left me-1"></i>Voltar para o inicio
            </a>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
