<?php
/**
 * Arena 7x7 - Detalhes da Partida
 */

define('ARENA7X7', true);
require_once 'includes/config.php';
require_once 'includes/db.php';
require_once 'includes/auth.php';
require_once 'includes/functions.php';

Auth::startSession();

$matchId = getInt('id');
$hash = getParam('h', '');

if (!$matchId) {
    setFlash('error', 'Partida nao encontrada.');
    redirect('matches.php');
}

// Validar hash para evitar enumerate de IDs
if (!empty($hash) && !validateMatchHash($matchId, $hash)) {
    setFlash('error', 'Link invalido.');
    redirect('matches.php');
}

// Buscar detalhes da partida
$match = getMatchDetails($matchId);

if (!$match) {
    setFlash('error', 'Partida nao encontrada.');
    redirect('matches.php');
}

$pageTitle = 'Detalhes da Partida';

// Buscar jogadores
$players = getMatchPlayers($matchId);
$teamBlue = array_filter($players, fn($p) => $p['team'] == 1);
$teamRed = array_filter($players, fn($p) => $p['team'] == 2);

// Buscar kills
$kills = getMatchKills($matchId);

// Buscar skills usadas (resumo)
$skills = getMatchSkills($matchId);

// Buscar log detalhado de skills
$skillLog = getMatchSkillLog($matchId);

// Buscar dano por alvo
$damageByTarget = getMatchDamageByTarget($matchId);

// Buscar ataques normais
$attacks = getMatchAttacks($matchId);

// Buscar itens consumidos
$items = getMatchItems($matchId);

// Buscar curas
$heals = getMatchHeals($matchId);

// Buscar assists
$assists = getMatchAssists($matchId);

// Calcular totais por time
$blueStats = ['damage' => 0, 'kills' => 0, 'deaths' => 0, 'healing' => 0];
$redStats = ['damage' => 0, 'kills' => 0, 'deaths' => 0, 'healing' => 0];

foreach ($players as $player) {
    if ($player['team'] == 1) {
        $blueStats['damage'] += $player['total_damage'];
        $blueStats['kills'] += $player['kills'];
        $blueStats['deaths'] += $player['deaths'];
        $blueStats['healing'] += $player['total_healing'];
    } else {
        $redStats['damage'] += $player['total_damage'];
        $redStats['kills'] += $player['kills'];
        $redStats['deaths'] += $player['deaths'];
        $redStats['healing'] += $player['total_healing'];
    }
}

$maxDamage = max($blueStats['damage'], $redStats['damage'], 1);
$maxHealing = max($blueStats['healing'], $redStats['healing'], 1);

include 'includes/header.php';
?>

<!-- Cabecalho da Partida -->
<div class="card mb-4">
    <div class="card-body">
        <div class="row align-items-center">
            <div class="col-md-4 text-center text-md-start">
                <a href="matches.php" class="btn btn-outline-secondary mb-3 mb-md-0">
                    <i class="bi bi-arrow-left me-2"></i>Voltar
                </a>
            </div>
            <div class="col-md-4 text-center">
                <h2 class="mb-1">Partida #<?= $matchId ?></h2>
                <p class="text-muted mb-0">
                    <i class="bi bi-calendar me-1"></i>
                    <?= formatDateTime($match['start_time']) ?>
                    <?php if (!empty($match['duration'])): ?>
                        <span class="ms-3">
                            <i class="bi bi-clock me-1"></i>
                            <?= formatDuration($match['duration']) ?>
                        </span>
                    <?php endif; ?>
                </p>
            </div>
            <div class="col-md-4 text-center text-md-end mt-3 mt-md-0">
                <?php if ($match['winner_team'] == 1): ?>
                    <span class="match-result match-result-victory fs-5">
                        <i class="bi bi-trophy me-1"></i><?= e($match['blue_guild_name']) ?> Venceu
                    </span>
                <?php elseif ($match['winner_team'] == 2): ?>
                    <span class="match-result match-result-defeat fs-5">
                        <i class="bi bi-trophy me-1"></i><?= e($match['red_guild_name']) ?> Venceu
                    </span>
                <?php else: ?>
                    <span class="match-result match-result-draw fs-5">
                        <i class="bi bi-dash-circle me-1"></i>Empate
                    </span>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Placar -->
<div class="card mb-4">
    <div class="card-body py-4">
        <div class="match-score">
            <div class="team-score team-blue">
                <div class="d-flex align-items-center justify-content-center gap-2 mb-2">
                    <?php if (!empty($match['blue_guild_id'])): ?>
                        <img src="<?= guildEmblem($match['blue_guild_id']) ?>" 
                             alt="Emblema" 
                             class="guild-emblem"
                             style="width: 24px; height: 24px;"
                             onerror="this.style.display='none'">
                    <?php endif; ?>
                    <div class="team-badge team-badge-blue"><?= e($match['blue_guild_name']) ?></div>
                </div>
                <span style="font-size: 4rem;"><?= $match['team_blue_score'] ?></span>
            </div>
            <div class="vs" style="font-size: 2rem;">VS</div>
            <div class="team-score team-red">
                <div class="d-flex align-items-center justify-content-center gap-2 mb-2">
                    <div class="team-badge team-badge-red"><?= e($match['red_guild_name']) ?></div>
                    <?php if (!empty($match['red_guild_id'])): ?>
                        <img src="<?= guildEmblem($match['red_guild_id']) ?>" 
                             alt="Emblema" 
                             class="guild-emblem"
                             style="width: 24px; height: 24px;"
                             onerror="this.style.display='none'">
                    <?php endif; ?>
                </div>
                <span style="font-size: 4rem;"><?= $match['team_red_score'] ?></span>
            </div>
        </div>
    </div>
</div>

<!-- Comparacao de Times -->
<div class="row g-4 mb-4">
    <div class="col-md-6">
        <div class="card h-100">
            <div class="card-header team-blue">
                <h5 class="mb-0 text-white">
                    <i class="bi bi-circle-fill me-2"></i><?= e($match['blue_guild_name']) ?>
                </h5>
            </div>
            <div class="card-body">
                <div class="row g-3 text-center">
                    <div class="col-3">
                        <div class="fs-4 fw-bold text-danger"><?= $blueStats['kills'] ?></div>
                        <small class="text-muted">Kills</small>
                    </div>
                    <div class="col-3">
                        <div class="fs-4 fw-bold text-secondary"><?= $blueStats['deaths'] ?></div>
                        <small class="text-muted">Deaths</small>
                    </div>
                    <div class="col-3">
                        <div class="fs-4 fw-bold text-info"><?= formatNumber($blueStats['damage']) ?></div>
                        <small class="text-muted">Dano</small>
                    </div>
                    <div class="col-3">
                        <div class="fs-4 fw-bold text-success"><?= formatNumber($blueStats['healing']) ?></div>
                        <small class="text-muted">Cura</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card h-100">
            <div class="card-header team-red">
                <h5 class="mb-0 text-white">
                    <i class="bi bi-circle-fill me-2"></i><?= e($match['red_guild_name']) ?>
                </h5>
            </div>
            <div class="card-body">
                <div class="row g-3 text-center">
                    <div class="col-3">
                        <div class="fs-4 fw-bold text-danger"><?= $redStats['kills'] ?></div>
                        <small class="text-muted">Kills</small>
                    </div>
                    <div class="col-3">
                        <div class="fs-4 fw-bold text-secondary"><?= $redStats['deaths'] ?></div>
                        <small class="text-muted">Deaths</small>
                    </div>
                    <div class="col-3">
                        <div class="fs-4 fw-bold text-info"><?= formatNumber($redStats['damage']) ?></div>
                        <small class="text-muted">Dano</small>
                    </div>
                    <div class="col-3">
                        <div class="fs-4 fw-bold text-success"><?= formatNumber($redStats['healing']) ?></div>
                        <small class="text-muted">Cura</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Barra de Comparacao -->
<div class="card mb-4">
    <div class="card-body">
        <h6 class="text-muted mb-3">Comparacao de Dano</h6>
        <div class="row align-items-center mb-3">
            <div class="col-2 text-end fw-bold text-primary"><?= formatNumber($blueStats['damage']) ?></div>
            <div class="col-8">
                <div class="progress" style="height: 24px;">
                    <div class="progress-bar bg-primary" style="width: <?= ($blueStats['damage'] / $maxDamage) * 50 ?>%"></div>
                    <div class="progress-bar bg-danger" style="width: <?= ($redStats['damage'] / $maxDamage) * 50 ?>%"></div>
                </div>
            </div>
            <div class="col-2 text-start fw-bold text-danger"><?= formatNumber($redStats['damage']) ?></div>
        </div>
        
        <h6 class="text-muted mb-3">Comparacao de Cura</h6>
        <div class="row align-items-center">
            <div class="col-2 text-end fw-bold text-primary"><?= formatNumber($blueStats['healing']) ?></div>
            <div class="col-8">
                <div class="progress" style="height: 24px;">
                    <div class="progress-bar bg-info" style="width: <?= ($blueStats['healing'] / $maxHealing) * 50 ?>%"></div>
                    <div class="progress-bar bg-success" style="width: <?= ($redStats['healing'] / $maxHealing) * 50 ?>%"></div>
                </div>
            </div>
            <div class="col-2 text-start fw-bold text-danger"><?= formatNumber($redStats['healing']) ?></div>
        </div>
    </div>
</div>

<!-- Tabs para detalhes -->
<ul class="nav nav-tabs mb-4" role="tablist">
    <li class="nav-item">
        <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab-players">
            <i class="bi bi-people me-2"></i>Jogadores
        </button>
    </li>
    <li class="nav-item">
        <button class="nav-link" data-bs-toggle="tab" data-bs-target="#tab-kills">
            <i class="bi bi-lightning me-2"></i>Kills (<?= count($kills) ?>)
        </button>
    </li>
    <li class="nav-item">
        <button class="nav-link" data-bs-toggle="tab" data-bs-target="#tab-damage">
            <i class="bi bi-crosshair me-2"></i>Dano por Alvo
        </button>
    </li>
    <li class="nav-item">
        <button class="nav-link" data-bs-toggle="tab" data-bs-target="#tab-skills">
            <i class="bi bi-magic me-2"></i>Skills (<?= count($skills) ?>)
        </button>
    </li>
    <li class="nav-item">
        <button class="nav-link" data-bs-toggle="tab" data-bs-target="#tab-attacks">
            <i class="bi bi-bullseye me-2"></i>Ataques
        </button>
    </li>
    <li class="nav-item">
        <button class="nav-link" data-bs-toggle="tab" data-bs-target="#tab-items">
            <i class="bi bi-box me-2"></i>Itens (<?= count($items) ?>)
        </button>
    </li>
    <li class="nav-item">
        <button class="nav-link" data-bs-toggle="tab" data-bs-target="#tab-healing">
            <i class="bi bi-heart-pulse me-2"></i>Curas
        </button>
    </li>
</ul>

<div class="tab-content">
    <!-- Tab Jogadores -->
    <div class="tab-pane fade show active" id="tab-players">
        <div class="row g-4">
            <!-- <?= e($match['blue_guild_name']) ?> -->
            <div class="col-lg-6">
                <h5 class="mb-3">
                    <span class="team-badge team-badge-blue me-2"><?= e($match['blue_guild_name']) ?></span>
                </h5>
                <?php foreach ($teamBlue as $player): ?>
                    <?php $playerKda = calculateKDA($player['kills'], $player['deaths'], $player['assists']); ?>
                    <div class="card mb-3 team-blue">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-auto">
                                    <div class="player-avatar">
                                        <img src="<?= classImage($player['class']) ?>" 
                                             alt="<?= e(getClassName($player['class'])) ?>"
                                             onerror="this.src='assets/images/placeholder.png'">
                                    </div>
                                </div>
                                <div class="col">
                                    <a href="<?= playerUrl($player['char_name']) ?>" class="player-name fs-5">
                                        <?= e($player['char_name']) ?>
                                    </a>
                                    <div class="player-class"><?= e(getClassName($player['class'])) ?></div>
                                </div>
                                <div class="col-auto text-center">
                                    <div class="fs-5">
                                        <span class="badge badge-kills"><?= $player['kills'] ?></span>
                                        <span class="badge badge-deaths"><?= $player['deaths'] ?></span>
                                        <span class="badge badge-assists"><?= $player['assists'] ?></span>
                                    </div>
                                    <small class="text-muted">KDA: <span class="<?= getKdaClass($playerKda) ?>"><?= number_format($playerKda, 2) ?></span></small>
                                </div>
                            </div>
                            <div class="row mt-3 text-center">
                                <div class="col-4">
                                    <small class="text-muted d-block">Dano</small>
                                    <span class="fw-bold text-danger"><?= formatNumber($player['total_damage']) ?></span>
                                </div>
                                <div class="col-4">
                                    <small class="text-muted d-block">Cura</small>
                                    <span class="fw-bold text-success"><?= formatNumber($player['total_healing']) ?></span>
                                </div>
                                <div class="col-4">
                                    <small class="text-muted d-block">Dano Recebido</small>
                                    <span class="fw-bold text-warning"><?= formatNumber($player['damage_taken']) ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            
            <!-- <?= e($match['red_guild_name']) ?> -->
            <div class="col-lg-6">
                <h5 class="mb-3">
                    <span class="team-badge team-badge-red me-2"><?= e($match['red_guild_name']) ?></span>
                </h5>
                <?php foreach ($teamRed as $player): ?>
                    <?php $playerKda = calculateKDA($player['kills'], $player['deaths'], $player['assists']); ?>
                    <div class="card mb-3 team-red">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-auto">
                                    <div class="player-avatar">
                                        <img src="<?= classImage($player['class']) ?>" 
                                             alt="<?= e(getClassName($player['class'])) ?>"
                                             onerror="this.src='assets/images/placeholder.png'">
                                    </div>
                                </div>
                                <div class="col">
                                    <a href="<?= playerUrl($player['char_name']) ?>" class="player-name fs-5">
                                        <?= e($player['char_name']) ?>
                                    </a>
                                    <div class="player-class"><?= e(getClassName($player['class'])) ?></div>
                                </div>
                                <div class="col-auto text-center">
                                    <div class="fs-5">
                                        <span class="badge badge-kills"><?= $player['kills'] ?></span>
                                        <span class="badge badge-deaths"><?= $player['deaths'] ?></span>
                                        <span class="badge badge-assists"><?= $player['assists'] ?></span>
                                    </div>
                                    <small class="text-muted">KDA: <span class="<?= getKdaClass($playerKda) ?>"><?= number_format($playerKda, 2) ?></span></small>
                                </div>
                            </div>
                            <div class="row mt-3 text-center">
                                <div class="col-4">
                                    <small class="text-muted d-block">Dano</small>
                                    <span class="fw-bold text-danger"><?= formatNumber($player['total_damage']) ?></span>
                                </div>
                                <div class="col-4">
                                    <small class="text-muted d-block">Cura</small>
                                    <span class="fw-bold text-success"><?= formatNumber($player['total_healing']) ?></span>
                                </div>
                                <div class="col-4">
                                    <small class="text-muted d-block">Dano Recebido</small>
                                    <span class="fw-bold text-warning"><?= formatNumber($player['damage_taken']) ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
    
    <!-- Tab Kills -->
    <div class="tab-pane fade" id="tab-kills">
        <?php if (empty($kills)): ?>
            <div class="card">
                <div class="card-body text-center py-5 text-muted">
                    <i class="bi bi-emoji-neutral fs-1 d-block mb-3"></i>
                    Nenhuma kill registrada nesta partida.
                </div>
            </div>
        <?php else: ?>
            <div class="card">
                <div class="table-responsive">
                    <table class="table table-striped mb-0">
                        <thead>
                            <tr>
                                <th>Killer</th>
                                <th>Skill</th>
                                <th>Vitima</th>
                                <th>Assistencias</th>
                                <th class="text-end">Dano Final</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($kills as $kill): ?>
                                <tr>
                                    <td>
                                        <a href="<?= playerUrl($kill['killer_name']) ?>" class="player-name">
                                            <?= e($kill['killer_name']) ?>
                                        </a>
                                    </td>
                                    <td>
                                        <?php if (!empty($kill['kill_skill_id'])): ?>
                                            <div class="d-flex align-items-center gap-2">
                                                <img src="<?= skillImage($kill['kill_skill_id']) ?>" 
                                                     alt="<?= e($kill['skill_name'] ?? 'Skill') ?>"
                                                     class="skill-icon"
                                                     onerror="this.style.display='none'">
                                                <span class="small"><?= e($kill['skill_name'] ?? '') ?></span>
                                            </div>
                                        <?php else: ?>
                                            <span class="text-secondary">Ataque Normal</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="<?= playerUrl($kill['victim_name']) ?>" class="player-name text-danger">
                                            <?= e($kill['victim_name']) ?>
                                        </a>
                                    </td>
                                    <td>
                                        <?php 
                                        $assistNames = [];
                                        if (!empty($kill['assist1_name'])) $assistNames[] = $kill['assist1_name'];
                                        if (!empty($kill['assist2_name'])) $assistNames[] = $kill['assist2_name'];
                                        if (!empty($assistNames)): ?>
                                            <span class="text-info small"><?= e(implode(', ', $assistNames)) ?></span>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-end text-danger fw-bold">
                                        <?= formatNumber($kill['final_damage'] ?? 0) ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php endif; ?>
    </div>
    
    <!-- Tab Dano por Alvo -->
    <div class="tab-pane fade" id="tab-damage">
        <?php if (empty($damageByTarget)): ?>
            <div class="card">
                <div class="card-body text-center py-5 text-muted">
                    <i class="bi bi-emoji-neutral fs-1 d-block mb-3"></i>
                    Nenhum dano por alvo registrado nesta partida.
                </div>
            </div>
        <?php else: ?>
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0"><i class="bi bi-crosshair me-2"></i>Damage Log</h6>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped mb-0">
                        <thead>
                            <tr>
                                <th>Atacante</th>
                                <th><i class="bi bi-arrow-right"></i></th>
                                <th>Alvo</th>
                                <th class="text-end">Dano Skill</th>
                                <th class="text-end">Dano Normal</th>
                                <th class="text-end">Dano Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($damageByTarget as $dmg): ?>
                                <tr>
                                    <td>
                                        <a href="<?= playerUrl($dmg['attacker_name']) ?>" class="player-name">
                                            <?= e($dmg['attacker_name']) ?>
                                        </a>
                                    </td>
                                    <td class="text-center text-muted"><i class="bi bi-arrow-right"></i></td>
                                    <td>
                                        <a href="<?= playerUrl($dmg['target_name']) ?>" class="player-name text-danger">
                                            <?= e($dmg['target_name']) ?>
                                        </a>
                                    </td>
                                    <td class="text-end">
                                        <span class="text-info"><?= formatNumber($dmg['skill_damage']) ?></span>
                                    </td>
                                    <td class="text-end">
                                        <span class="text-warning"><?= formatNumber($dmg['normal_damage']) ?></span>
                                    </td>
                                    <td class="text-end">
                                        <span class="text-danger fw-bold"><?= formatNumber($dmg['total_damage']) ?></span>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php endif; ?>
    </div>
    
    <!-- Tab Skills -->
    <div class="tab-pane fade" id="tab-skills">
        <?php if (empty($skills)): ?>
            <div class="card">
                <div class="card-body text-center py-5 text-muted">
                    <i class="bi bi-emoji-neutral fs-1 d-block mb-3"></i>
                    Nenhuma skill registrada nesta partida.
                </div>
            </div>
        <?php else: ?>
            <div class="card">
                <div class="table-responsive">
                    <table class="table table-striped mb-0">
                        <thead>
                            <tr>
                                <th>Skill</th>
                                <th>Jogador</th>
                                <th class="text-center">Usos</th>
                                <th class="text-center">Hits</th>
                                <th class="text-center">Kills</th>
                                <th class="text-end">Dano Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($skills as $skill): ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center gap-2">
                                            <img src="<?= skillImage($skill['skill_id']) ?>" 
                                                 alt="<?= e($skill['skill_name'] ?? 'Skill') ?>"
                                                 class="skill-icon"
                                                 onerror="this.style.display='none'">
                                            <span><?= e($skill['skill_name'] ?? 'Skill #' . $skill['skill_id']) ?></span>
                                        </div>
                                    </td>
                                    <td>
                                        <?php if (!empty($skill['char_name'])): ?>
                                            <a href="<?= playerUrl($skill['char_name']) ?>" class="player-name">
                                                <?= e($skill['char_name']) ?>
                                            </a>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center">
                                        <?= $skill['times_used'] ?? 0 ?>
                                    </td>
                                    <td class="text-center">
                                        <?= $skill['hit_count'] ?? $skill['times_used'] ?? 0 ?>
                                    </td>
                                    <td class="text-center">
                                        <?php if (!empty($skill['kill_count'])): ?>
                                            <span class="badge bg-danger"><?= $skill['kill_count'] ?></span>
                                        <?php else: ?>
                                            <span class="text-muted">0</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-end text-danger fw-bold">
                                        <?= formatNumber($skill['damage_dealt']) ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php endif; ?>
    </div>
    
    <!-- Tab Ataques Normais -->
    <div class="tab-pane fade" id="tab-attacks">
        <?php if (empty($attacks)): ?>
            <div class="card">
                <div class="card-body text-center py-5 text-muted">
                    <i class="bi bi-emoji-neutral fs-1 d-block mb-3"></i>
                    Nenhum ataque normal registrado nesta partida.
                </div>
            </div>
        <?php else: ?>
            <div class="card">
                <div class="table-responsive">
                    <table class="table table-striped mb-0">
                        <thead>
                            <tr>
                                <th>Atacante</th>
                                <th>Alvo</th>
                                <th class="text-center">Hits</th>
                                <th class="text-center">Criticos</th>
                                <th class="text-center">Misses</th>
                                <th class="text-end">Dano Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($attacks as $attack): ?>
                                <tr>
                                    <td>
                                        <a href="<?= playerUrl($attack['attacker_name']) ?>" class="player-name">
                                            <?= e($attack['attacker_name']) ?>
                                        </a>
                                    </td>
                                    <td>
                                        <a href="<?= playerUrl($attack['target_name']) ?>" class="player-name text-danger">
                                            <?= e($attack['target_name']) ?>
                                        </a>
                                    </td>
                                    <td class="text-center"><?= $attack['hit_count'] ?></td>
                                    <td class="text-center">
                                        <?php if ($attack['critical_count'] > 0): ?>
                                            <span class="text-warning fw-bold"><?= $attack['critical_count'] ?></span>
                                        <?php else: ?>
                                            <span class="text-muted">0</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center text-muted"><?= $attack['miss_count'] ?></td>
                                    <td class="text-end text-danger fw-bold">
                                        <?= formatNumber($attack['total_damage']) ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php endif; ?>
    </div>
    
    <!-- Tab Itens Consumidos -->
    <div class="tab-pane fade" id="tab-items">
        <?php if (empty($items)): ?>
            <div class="card">
                <div class="card-body text-center py-5 text-muted">
                    <i class="bi bi-emoji-neutral fs-1 d-block mb-3"></i>
                    Nenhum item consumido registrado nesta partida.
                </div>
            </div>
        <?php else: ?>
            <div class="card">
                <div class="table-responsive">
                    <table class="table table-striped mb-0">
                        <thead>
                            <tr>
                                <th>Item</th>
                                <th>Jogador</th>
                                <th>Tipo</th>
                                <th class="text-end">Quantidade</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($items as $item): ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center gap-2">
                                            <img src="<?= itemImage($item['item_id']) ?>" 
                                                 alt="<?= e($item['item_name'] ?? 'Item') ?>"
                                                 class="item-icon"
                                                 style="width: 24px; height: 24px;"
                                                 onerror="this.style.display='none'">
                                            <span><?= e($item['item_name'] ?? 'Item #' . $item['item_id']) ?></span>
                                        </div>
                                    </td>
                                    <td>
                                        <a href="<?= playerUrl($item['char_name']) ?>" class="player-name">
                                            <?= e($item['char_name']) ?>
                                        </a>
                                    </td>
                                    <td>
                                        <?php 
                                        $typeLabels = [
                                            'arrow' => '<span class="badge bg-warning">Flecha</span>',
                                            'gemstone' => '<span class="badge bg-info">Gema</span>',
                                            'potion' => '<span class="badge bg-success">Pocao</span>',
                                            'catalyst' => '<span class="badge bg-secondary">Catalisador</span>',
                                            'other' => '<span class="badge bg-light text-dark">Outro</span>'
                                        ];
                                        echo $typeLabels[$item['item_type']] ?? $typeLabels['other'];
                                        ?>
                                    </td>
                                    <td class="text-end fw-bold"><?= formatNumber($item['amount']) ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php endif; ?>
    </div>
    
    <!-- Tab Healing -->
    <div class="tab-pane fade" id="tab-healing">
        <?php if (empty($heals)): ?>
            <div class="card">
                <div class="card-body text-center py-5 text-muted">
                    <i class="bi bi-emoji-neutral fs-1 d-block mb-3"></i>
                    Nenhuma cura registrada nesta partida.
                </div>
            </div>
        <?php else: ?>
            <div class="card">
                <div class="table-responsive">
                    <table class="table table-striped mb-0">
                        <thead>
                            <tr>
                                <th>Curador</th>
                                <th>Alvo</th>
                                <th>Skill</th>
                                <th class="text-end">Quantidade</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($heals as $heal): ?>
                                <tr>
                                    <td>
                                        <a href="<?= playerUrl($heal['healer_name']) ?>" class="player-name">
                                            <?= e($heal['healer_name']) ?>
                                        </a>
                                    </td>
                                    <td>
                                        <a href="<?= playerUrl($heal['target_name']) ?>" class="player-name text-success">
                                            <?= e($heal['target_name']) ?>
                                        </a>
                                    </td>
                                    <td>
                                        <?php if (!empty($heal['skill_id'])): ?>
                                            <div class="d-flex align-items-center gap-2">
                                                <img src="<?= skillImage($heal['skill_id']) ?>" 
                                                     alt="<?= e($heal['skill_name'] ?? 'Skill') ?>"
                                                     class="skill-icon"
                                                     onerror="this.style.display='none'">
                                                <span class="small"><?= e($heal['skill_name'] ?? '') ?></span>
                                            </div>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-end text-success fw-bold">
                                        +<?= formatNumber($heal['heal_amount']) ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
