<?php
/**
 * Arena 7x7 - Meu Perfil (Requer Login)
 */

define('ARENA7X7', true);
require_once 'includes/config.php';
require_once 'includes/db.php';
require_once 'includes/auth.php';
require_once 'includes/functions.php';

Auth::startSession();

// Verificar login
if (!Auth::isLoggedIn()) {
    setFlash('error', 'Voce precisa estar logado para ver seu perfil.');
    redirect('login.php');
}

$pageTitle = 'Meu Perfil';
$user = Auth::getUser();

// Buscar personagens do usuario
$characters = Auth::getCharacters();

// Calcular estatisticas totais
$totalStats = [
    'matches' => 0,
    'wins' => 0,
    'losses' => 0,
    'kills' => 0,
    'deaths' => 0,
    'assists' => 0,
    'damage' => 0,
    'healing' => 0,
    'rating' => 0
];

$charStats = [];

foreach ($characters as $char) {
    $stats = getPlayerStats($char['char_id']);
    if ($stats) {
        $charStats[$char['char_id']] = $stats;
        $totalStats['matches'] += $stats['matches_played'];
        $totalStats['wins'] += $stats['wins'];
        $totalStats['losses'] += $stats['losses'];
        $totalStats['kills'] += $stats['total_kills'];
        $totalStats['deaths'] += $stats['total_deaths'];
        $totalStats['assists'] += $stats['total_assists'];
        $totalStats['damage'] += $stats['total_damage'];
        $totalStats['healing'] += $stats['total_healing'];
        $totalStats['rating'] = max($totalStats['rating'], $stats['rating_points']);
    }
}

$winRate = calculateWinRate($totalStats['wins'], $totalStats['matches']);
$kda = calculateKDA($totalStats['kills'], $totalStats['deaths'], $totalStats['assists']);

// Buscar melhor personagem
$bestChar = null;
$bestRating = 0;
foreach ($charStats as $charId => $stats) {
    if ($stats['rating_points'] > $bestRating) {
        $bestRating = $stats['rating_points'];
        $bestChar = $charId;
    }
}

include 'includes/header.php';
?>

<div class="mb-4">
    <h1 class="mb-1"><i class="bi bi-person-circle me-2 text-primary"></i>Meu Perfil</h1>
    <p class="text-muted mb-0">Conta: <strong><?= e($user['userid']) ?></strong></p>
</div>

<!-- Resumo Geral -->
<div class="card mb-4">
    <div class="card-header">
        <h5 class="card-title mb-0">
            <i class="bi bi-graph-up me-2"></i>Estatisticas Gerais da Conta
        </h5>
    </div>
    <div class="card-body">
        <div class="row g-4 text-center">
            <div class="col-md-2 col-6">
                <div class="fs-3 fw-bold text-warning"><?= formatNumber($totalStats['rating']) ?></div>
                <small class="text-muted">Maior Rating</small>
            </div>
            <div class="col-md-2 col-6">
                <div class="fs-3 fw-bold"><?= $totalStats['matches'] ?></div>
                <small class="text-muted">Partidas</small>
            </div>
            <div class="col-md-2 col-6">
                <div class="fs-3 fw-bold text-success"><?= $totalStats['wins'] ?></div>
                <small class="text-muted">Vitorias</small>
            </div>
            <div class="col-md-2 col-6">
                <div class="fs-3 fw-bold <?= getWinRateClass($winRate) ?>"><?= $winRate ?>%</div>
                <small class="text-muted">Win Rate</small>
            </div>
            <div class="col-md-2 col-6">
                <div class="fs-3 fw-bold text-danger"><?= $totalStats['kills'] ?></div>
                <small class="text-muted">Total Kills</small>
            </div>
            <div class="col-md-2 col-6">
                <div class="fs-3 fw-bold <?= getKdaClass($kda) ?>"><?= number_format($kda, 2) ?></div>
                <small class="text-muted">KDA Geral</small>
            </div>
        </div>
    </div>
</div>

<!-- Personagens -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="card-title mb-0">
            <i class="bi bi-people me-2"></i>Meus Personagens
            <span class="badge bg-primary ms-2"><?= count($characters) ?></span>
        </h5>
        <a href="my_matches.php" class="btn btn-sm btn-outline-primary">
            <i class="bi bi-list me-1"></i>Ver Todas Partidas
        </a>
    </div>
    
    <?php if (empty($characters)): ?>
        <div class="card-body text-center py-5">
            <i class="bi bi-emoji-frown fs-1 d-block mb-3 text-muted"></i>
            <h5 class="text-muted">Nenhum personagem encontrado</h5>
            <p class="text-muted mb-0">Crie um personagem no servidor para comecar a jogar!</p>
        </div>
    <?php else: ?>
        <div class="card-body">
            <div class="row g-4">
                <?php foreach ($characters as $char): ?>
                    <?php 
                        $stats = $charStats[$char['char_id']] ?? null;
                        $isBest = ($bestChar == $char['char_id']);
                    ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="card h-100 <?= $isBest ? 'border-warning' : '' ?>">
                            <?php if ($isBest && $stats): ?>
                                <div class="card-header bg-warning text-dark text-center py-1">
                                    <small><i class="bi bi-star-fill me-1"></i>Melhor Personagem</small>
                                </div>
                            <?php endif; ?>
                            <div class="card-body">
                                <div class="d-flex align-items-center gap-3 mb-3">
                                    <div class="player-avatar" style="width: 80px; height: 80px;">
                                        <img src="<?= classImage($char['class']) ?>" 
                                             alt="<?= e(getClassName($char['class'])) ?>"
                                             style="width: 100%; height: 100%;"
                                             onerror="this.src='assets/images/placeholder.png'">
                                    </div>
                                    <div>
                                        <h5 class="mb-1"><?= e($char['name']) ?></h5>
                                        <p class="text-muted mb-0">
                                            <?= e(getClassName($char['class'])) ?><br>
                                            <small>Base Lv.<?= $char['base_level'] ?> / Job Lv.<?= $char['job_level'] ?></small>
                                        </p>
                                    </div>
                                </div>
                                
                                <?php if ($stats): ?>
                                    <div class="row g-2 text-center mb-3">
                                        <div class="col-4">
                                            <div class="fw-bold text-warning"><?= formatNumber($stats['rating_points']) ?></div>
                                            <small class="text-muted">Rating</small>
                                        </div>
                                        <div class="col-4">
                                            <div class="fw-bold"><?= $stats['matches_played'] ?></div>
                                            <small class="text-muted">Partidas</small>
                                        </div>
                                        <div class="col-4">
                                            <?php $charWinRate = calculateWinRate($stats['wins'], $stats['matches_played']); ?>
                                            <div class="fw-bold <?= getWinRateClass($charWinRate) ?>"><?= $charWinRate ?>%</div>
                                            <small class="text-muted">Win Rate</small>
                                        </div>
                                    </div>
                                    
                                    <div class="row g-2 text-center mb-3">
                                        <div class="col-4">
                                            <span class="badge badge-kills fs-6"><?= $stats['total_kills'] ?></span>
                                            <small class="text-muted d-block">Kills</small>
                                        </div>
                                        <div class="col-4">
                                            <span class="badge badge-deaths fs-6"><?= $stats['total_deaths'] ?></span>
                                            <small class="text-muted d-block">Deaths</small>
                                        </div>
                                        <div class="col-4">
                                            <span class="badge badge-assists fs-6"><?= $stats['total_assists'] ?></span>
                                            <small class="text-muted d-block">Assists</small>
                                        </div>
                                    </div>
                                    
                                    <?php $charKda = calculateKDA($stats['total_kills'], $stats['total_deaths'], $stats['total_assists']); ?>
                                    <div class="text-center mb-3">
                                        <span class="<?= getKdaClass($charKda) ?> fw-bold fs-5">
                                            KDA: <?= number_format($charKda, 2) ?>
                                        </span>
                                    </div>
                                    
                                    <a href="player.php?id=<?= $char['char_id'] ?>" class="btn btn-primary w-100">
                                        <i class="bi bi-eye me-2"></i>Ver Perfil Completo
                                    </a>
                                <?php else: ?>
                                    <div class="text-center py-3">
                                        <span class="badge bg-secondary">Sem partidas na Arena</span>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>
</div>

<?php include 'includes/footer.php'; ?>
