<?php
/**
 * Arena 7x7 - Ranking Completo
 */

define('ARENA7X7', true);
require_once 'includes/config.php';
require_once 'includes/db.php';
require_once 'includes/auth.php';
require_once 'includes/functions.php';

Auth::startSession();

$pageTitle = 'Ranking';

// Paginacao
$page = max(1, getInt('page', 1));
$perPage = ITEMS_PER_PAGE;
$offset = ($page - 1) * $perPage;

// Total de jogadores
$totalPlayers = countPlayersWithMatches();
$totalPages = ceil($totalPlayers / $perPage);

// Buscar jogadores
$players = getTopPlayers($perPage, $offset);

include 'includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h1 class="mb-1"><i class="bi bi-bar-chart me-2 text-primary"></i>Ranking</h1>
        <p class="text-muted mb-0">Os melhores jogadores da Arena 7x7</p>
    </div>
    <div>
        <span class="badge bg-primary fs-6">
            <i class="bi bi-people me-1"></i><?= formatNumber($totalPlayers) ?> jogadores
        </span>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body py-3">
        <div class="row g-3 align-items-center">
            <div class="col-md-6">
                <div class="input-group">
                    <span class="input-group-text bg-transparent">
                        <i class="bi bi-search"></i>
                    </span>
                    <input type="text" 
                           class="form-control" 
                           id="tableSearch" 
                           data-table="#rankingTable"
                           placeholder="Buscar jogador...">
                </div>
            </div>
            <div class="col-md-6 text-md-end">
                <div class="btn-group" role="group">
                    <a href="ranking.php?sort=rating" class="btn btn-outline-secondary <?= getParam('sort', 'rating') == 'rating' ? 'active' : '' ?>">
                        Por Rating
                    </a>
                    <a href="ranking.php?sort=wins" class="btn btn-outline-secondary <?= getParam('sort') == 'wins' ? 'active' : '' ?>">
                        Por Vitorias
                    </a>
                    <a href="ranking.php?sort=kda" class="btn btn-outline-secondary <?= getParam('sort') == 'kda' ? 'active' : '' ?>">
                        Por KDA
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Tabela de Ranking -->
<div class="card ranking-table">
    <div class="table-responsive">
        <table class="table table-striped mb-0" id="rankingTable">
            <thead>
                <tr>
                    <th style="width: 70px;">Posicao</th>
                    <th>Jogador</th>
                    <th class="text-center">Pontos</th>
                    <th class="text-center">Partidas</th>
                    <th class="text-center">V/D/E</th>
                    <th class="text-center">Win Rate</th>
                    <th class="text-center">K/D/A</th>
                    <th class="text-center">KDA</th>
                    <th class="text-center">Dano Total</th>
                    <th class="text-center">Cura Total</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($players)): ?>
                    <tr>
                        <td colspan="10" class="text-center text-muted py-5">
                            <i class="bi bi-emoji-frown fs-1 d-block mb-3"></i>
                            Nenhum jogador encontrado ainda.<br>
                            <small>Participe de partidas para aparecer no ranking!</small>
                        </td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($players as $index => $player): ?>
                        <?php 
                            $position = $offset + $index + 1;
                            $kda = calculateKDA($player['total_kills'], $player['total_deaths'], $player['total_assists']);
                            $kdaClass = getKdaClass($kda);
                            $winRate = calculateWinRate($player['wins'], $player['matches_played']);
                            $winRateClass = getWinRateClass($winRate);
                        ?>
                        <tr>
                            <td>
                                <span class="rank-position rank-<?= $position <= 3 ? $position : 'default' ?>">
                                    <?= $position ?>
                                </span>
                            </td>
                            <td>
                                <div class="player-info">
                                    <div class="player-avatar">
                                        <img src="<?= classImage($player['class']) ?>" 
                                             alt="<?= e(getClassName($player['class'])) ?>"
                                             onerror="this.src='assets/images/placeholder.png'">
                                    </div>
                                    <div>
                                        <a href="<?= playerUrl($player['char_name']) ?>" class="player-name">
                                            <?= e($player['char_name']) ?>
                                        </a>
                                        <div class="player-class">
                                            <?= e(getClassName($player['class'])) ?> Lv.<?= $player['base_level'] ?>
                                        </div>
                                    </div>
                                </div>
                            </td>
                            <td class="text-center">
                                <span class="text-warning fw-bold fs-5"><?= formatNumber($player['rating_points']) ?></span>
                            </td>
                            <td class="text-center">
                                <?= $player['matches_played'] ?>
                            </td>
                            <td class="text-center">
                                <span class="text-success fw-bold"><?= $player['wins'] ?></span>
                                <span class="text-muted">/</span>
                                <span class="text-danger fw-bold"><?= $player['losses'] ?></span>
                                <span class="text-muted">/</span>
                                <span class="text-secondary"><?= $player['ties'] ?? 0 ?></span>
                            </td>
                            <td class="text-center">
                                <span class="<?= $winRateClass ?> fw-bold"><?= $winRate ?>%</span>
                            </td>
                            <td class="text-center">
                                <span class="badge badge-kills"><?= $player['total_kills'] ?></span>
                                <span class="badge badge-deaths"><?= $player['total_deaths'] ?></span>
                                <span class="badge badge-assists"><?= $player['total_assists'] ?></span>
                            </td>
                            <td class="text-center">
                                <span class="<?= $kdaClass ?> fw-bold"><?= number_format($kda, 2) ?></span>
                            </td>
                            <td class="text-center">
                                <?= formatNumber($player['total_damage']) ?>
                            </td>
                            <td class="text-center text-success">
                                <?= formatNumber($player['total_healing']) ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Paginacao -->
<?php if ($totalPages > 1): ?>
    <div class="mt-4">
        <?= paginate($page, $totalPages, 'ranking.php?sort=' . e(getParam('sort', 'rating'))) ?>
    </div>
<?php endif; ?>

<?php include 'includes/footer.php'; ?>
