<?php
/**
 * Arena 7x7 - Teste de Configuracao
 * Acesse este arquivo para verificar se tudo esta funcionando
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Teste Arena 7x7</h1>";

// Teste 1: PHP funcionando
echo "<h2>1. PHP</h2>";
echo "<p>Versao: " . phpversion() . "</p>";
echo "<p style='color:green;'>✓ PHP funcionando!</p>";

// Teste 2: Extensao PDO
echo "<h2>2. PDO</h2>";
if (extension_loaded('pdo_mysql')) {
    echo "<p style='color:green;'>✓ PDO MySQL habilitado!</p>";
} else {
    echo "<p style='color:red;'>✗ PDO MySQL NAO habilitado!</p>";
}

// Teste 3: Incluir config
echo "<h2>3. Configuracao</h2>";
try {
    define('ARENA7X7', true);
    require_once 'includes/config.php';
    echo "<p style='color:green;'>✓ Config carregado!</p>";
    echo "<p>DB_HOST: " . DB_HOST . "</p>";
    echo "<p>DB_NAME: " . DB_NAME . "</p>";
} catch (Exception $e) {
    echo "<p style='color:red;'>✗ Erro: " . $e->getMessage() . "</p>";
}

// Teste 4: Conexao com banco
echo "<h2>4. Banco de Dados</h2>";
try {
    require_once 'includes/db.php';
    $db = db();
    echo "<p style='color:green;'>✓ Conexao com banco OK!</p>";
    
    // Teste de query
    $result = $db->fetchColumn("SELECT 1");
    echo "<p style='color:green;'>✓ Query teste OK!</p>";
    
    // Verificar tabelas
    $tables = $db->fetchAll("SHOW TABLES LIKE 'arena7x7_%'");
    echo "<p>Tabelas arena7x7 encontradas: " . count($tables) . "</p>";
    foreach ($tables as $t) {
        echo "<p>- " . array_values($t)[0] . "</p>";
    }
    
} catch (Exception $e) {
    echo "<p style='color:red;'>✗ Erro: " . $e->getMessage() . "</p>";
}

// Teste 5: Sessao
echo "<h2>5. Sessao</h2>";
try {
    require_once 'includes/auth.php';
    Auth::startSession();
    echo "<p style='color:green;'>✓ Sessao iniciada!</p>";
} catch (Exception $e) {
    echo "<p style='color:red;'>✗ Erro: " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<p><a href='index.php'>Ir para o site</a></p>";
